<?php
session_start();
if ($_GET['utm_campaign'] != "") {

  $_SESSION["campaign_name"] = $_GET['utm_campaign'];
  $_SESSION["ad_group"] = $_GET['utm_medium'];
  $_SESSION["ads"] = $_GET['utm_content'];
  $_SESSION["sourcecampaign"] = $_GET['utm_source'];
} elseif ($_GET['campaign'] != "") {
  $_SESSION["campaign_name"] = $_GET['campaign'];
  $_SESSION["ad_group"] = $_GET['adgroup'];
  $_SESSION["ads"] = $_GET['keyword'];
  $_SESSION["sourcecampaign"] = $_GET['medium'];
} else {
}
?>

<!doctype html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="shortcut icon" href="images/favicon1.png" />
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <title>DY Patil Vidyapeeth Online , Mumbai – Fees, Admission</title>
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/owl.carousel.min.css" />
  <link rel="stylesheet" href="css/owl.theme.default.min.css" />
  <script src="https://kit.fontawesome.com/21c10b9af1.js" async crossorigin="anonymous"></script>
  <link rel="stylesheet" type="text/css" href="css/style.css">
  <link rel="stylesheet" type="text/css" href="css/responsive.css">

  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=AW-536503335"></script>
  <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
      dataLayer.push(arguments);
    }
    gtag('js', new Date());
    gtag('config', 'AW-536503335');
  </script>

  <style>
    .disabledBtn {
      position: absolute;
      inset: 0;
    }

    .lead-form-lead-point {
      color: #16b1a2;
      font-size: 12px;
      font-weight: 600;
    }

    footer ul li {
      display: block;
      line-height: 32px;
      font-weight: 300;
      cursor: pointer;
    }
  </style>

</head>

<body>

  <header class="py-2 shadow border-bottom">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-6 pe-0">
          <div class="logo">
            <a href="https://onlinedypatil.com/">
              <img src="images/logo.webp" alt="Logo" class="mainlogo">
            </a>
          </div>
        </div>
        <div class="col-6 ps-0">
          <div class="logo text-end">
            <button class="btn button_main px-4 rounded-pill" type="button" data-bs-toggle="modal" data-bs-target="#call_download">Apply Now</button>
          </div>
        </div>
      </div>
    </div>
  </header>

  <section class="home_banner seciton_padding">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-sm-6">
          <div class="banner-content">
            <h1 class="fw-bold HeroHeading mb-4 colorBlue">Dr. D.Y.Patil Vidyapeeth Online, Mumbai</h1>
            <div class="courseList">
              <a href="#All-Course"><span>MBA</span></a>
              <a href="#All-Course"><span>BBA</span></a>
            </div>
            <p>Boost Your Career with India’s Only Comfort Learning Platform</p>
            <div class="d-none d-sm-block">
              <button class="btn button_main clickPop" type="button" data-bs-toggle="modal" data-bs-target="#brochur_download">
                <i class="fas fa-download"></i> Download Brochure</button>
              <button class="btn button_main" type="button" data-bs-toggle="modal" data-bs-target="#apply_download"> Apply Now</button>
              <h5 class="text-dark mt-1 mt-sm-4">Admissions Open </h5>
              <small class="d-inline-block bgBlue px-3 rounded" style="color: #fff7ed;">Avail No Cost EMI's</small>
            </div>
          </div>
        </div>
        <div class="col-sm-6">
          <div class="banner_img overflow-hidden rounded">
            <img src="images/banner-img.webp" alt="Banner" width="100%">
          </div>
          <div class="d-block d-sm-none mt-3 text-center">
            <button class="btn button_main clickPop" type="button" data-bs-toggle="modal" data-bs-target="#brochur_download">
              <i class="fas fa-download"></i> Download Brochure</button>
            <button class="btn button_main" type="button" data-bs-toggle="modal" data-bs-target="#apply_download"> Apply Now</button>
            <h5 class="text-dark mt-3" style="font-size: 16px;">Admissions Open </h5>
            <small class="d-inline-block bgBlue px-3 rounded" style="color: #fff7ed;">Avail No Cost EMI's</small>
          </div>
        </div>
      </div>
    </div>
  </section>

  <div class="common_form d-block d-sm-none pt-4 shadow-lg">
    <div class="text-center mb-4">
      <p class="mb-0">Speak to an admission counsellor</p>
      <span class="d-block text-center text-danger fw-bold">Avail No Cost EMI's</span>
      <ul class="d-flex justify-content-center list-unstyled lead-form-lead-point">
        <li class="mx-1">
          <svg width="15" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-1" viewBox="0 0 20 20" fill="currentColor">
            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
          </svg> Online Exam
        </li>
        <li class="mx-1">
          <svg width="15" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-1" viewBox="0 0 20 20" fill="currentColor">
            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
          </svg> 100% Placement Assistance
        </li>
      </ul>
    </div>
    <form method="post" action="submit_form.php">
      <input type="text" name="name" class="form-control popDisabled" placeholder="Enter Name" required="">
      <input type="email" name="email" class="form-control popDisabled" placeholder="Enter email" required="">
      <div class="position-relative">
        <input type="tel" name="contactno" pattern="^[6-9]\d{9}$" maxlength="10" class="form-control popDisabled" placeholder="Enter Phone No." required="">
        <span class="position-absolute end-0 me-2 px-2 rounded-bottom text-success" style="bottom: -13px; background-color: rgb(212, 254, 232); font-size: 10px;"><svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-shield-fill-check" viewBox="0 0 16 16">
            <path fill-rule="evenodd" d="M8 0c-.69 0-1.843.265-2.928.56-1.11.3-2.229.655-2.887.87a1.54 1.54 0 0 0-1.044 1.262c-.596 4.477.787 7.795 2.465 9.99a11.777 11.777 0 0 0 2.517 2.453c.386.273.744.482 1.048.625.28.132.581.24.829.24s.548-.108.829-.24a7.159 7.159 0 0 0 1.048-.625 11.775 11.775 0 0 0 2.517-2.453c1.678-2.195 3.061-5.513 2.465-9.99a1.541 1.541 0 0 0-1.044-1.263 62.467 62.467 0 0 0-2.887-.87C9.843.266 8.69 0 8 0zm2.146 5.146a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647z"></path>
          </svg> We don't spam </span>
      </div>
      <select required="" name="city" class="form-select mb-3 stateData popDisabled">
        <option selected="" disabled="" value="">Select State </option>
      </select>
      <select required name="selectcourse" class="form-select mb-3 popDisabled">
        <option value="" selected="" disabled="">Select Course</option>
        <option value="1">MBA</option>
        <option value="5">BBA</option>
      </select>
      <input type="hidden" value="pop" name="from">
      <p class="py-1 px-2 rounded" style="background:aliceblue;">
        <small class="d-block">
          <img src="images/certified-icon.svg" width="23px"> Only a certified mentor will assist you
        </small>
      </p>
      <div class="text-center positon-relative">
        <div class="disabledBtn d-none"></div>
        <button type="submit" name="submit" class="button_main btn loader_btn">Apply Now</button>
      </div>
    </form>
  </div>

  <section class="top_ranked seciton_padding">
    <div class="container">
      <div class="row">
        <div class="col-sm-12">
          <div class="headingbox text-center">
            <h3 class="fw-bold">Dr. D.Y.Patil Vidyapeeth, Mumbai</h3>
            <p>Accreditation and Recognition</p>
          </div>
          <div class="owl-carousel owl-theme topRanked">
            <div class="item position-relative py-2">
              <div class="ranked-img">
                <img src="images/UGC.webp" alt="ugc">
              </div>
              <div class="ranked-body bg-white border">
                <p class="mb-0">UGC(University Grants Commission) Approved</p>
              </div>
            </div>
            <div class="item position-relative py-2">
              <div class="ranked-img">
                <img src="images/AICTE.webp" alt="aicte">
              </div>
              <div class="ranked-body bg-white border">
                <p class="mb-0">AICTE (All India Council for Technical Education) Approved</p>
              </div>
            </div>
            <div class="item position-relative py-2">
              <div class="ranked-img">
                <img src="images/NAAC.webp" alt="NAAC">
              </div>
              <div class="ranked-body bg-white border">
                <p class="mb-0">NAAC “A++” Grade Accredited</p>
              </div>
            </div>
            <div class="item position-relative py-2">
              <div class="ranked-img">
                <img src="images/NIRF.webp" alt="Approval">
              </div>
              <div class="ranked-body bg-white border">
                <p class="mb-0">Top Rank Universities (NIRF-2023)</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="reason_sec seciton_padding">
    <div class="container">
      <div class="row">
        <div class="col-sm-12">
          <div class="headingbox text-center">
            <div class="logo mb-2">
              <img src="images/logo.webp" alt="Logo" class="mainlogoss">
            </div>
            <h5 class="fw-600">Achieve Your Online Degree From India’s Top Comfort Learning Platform</h5>
            <p class="mb-0 fw-500">Member of the Association of Commonwealth Universities</p>
            <p class="mt-0"><small>Why Pursue Online Degree from DY Patil University (Mumbai)</small></p>
          </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 mb-4 ReasonCardDiv">
          <div class="reason_card h-100" style="background:linear-gradient(161.7deg, #223543 13.03%, #ED3237 -8.74%, #fb9966 94.03%);">
            <div class="d-flex gap-2 align-items-center mb-4">
              <img src="images/industry-project.png" alt="Holistic Development" style="filter: opacity(0.7);">
              <h6 class="mb-0 text-white">Easy Time- Management</h6>
            </div>
            <div class="d-flex gap-2 gap-sm-3 mb-3">
              <div class="reason_icon"><i class="fas fa-check"></i></div>
              <div class="reason_text">24/7 access to live and recorded lectures allow study along with professional commitments.</div>
            </div>

          </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 mb-4 ReasonCardDiv">
          <div class="reason_card h-100" style="background:linear-gradient(161.7deg, #223543 13.03%, #ED3237 -8.74%, #fb9966 94.03%);">
            <div class="d-flex gap-2 align-items-center mb-4">
              <img src="images/certificate.png" alt="Academic" style="filter: opacity(0.7);">
              <h6 class="mb-0 text-white">Access to Analytical & BI Learning Tools</h6>
            </div>
            <div class="d-flex gap-2 gap-sm-3 mb-3">
              <div class="reason_icon"><i class="fas fa-check"></i></div>
              <div class="reason_text">Detailed learning videos on MS Excel & Tableau to step-up data presentation & visualization skills.</div>
            </div>

          </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 mb-4 ReasonCardDiv">
          <div class="reason_card h-100" style="background:linear-gradient(161.7deg, #223543 13.03%, #ED3237 -8.74%, #fb9966 94.03%);">
            <div class="d-flex gap-2 align-items-center mb-4">
              <img src="images/salary.png" alt="Build" style="filter: opacity(0.7);">
              <h6 class="mb-0 text-white">Career Assistance</h6>
            </div>
            <div class="d-flex gap-2 gap-sm-3 mb-3">
              <div class="reason_icon"><i class="fas fa-check"></i></div>
              <div class="reason_text">Gain academics guidance along with Placement and career support</div>
            </div>

          </div>
        </div>
        <div class="col-lg-3 col-md-6 col-sm-6 mb-4 ReasonCardDiv">
          <div class="reason_card h-100" style="background:linear-gradient(161.7deg, #223543 13.03%, #ED3237 -8.74%, #fb9966 94.03%);">
            <div class="d-flex gap-2 align-items-center mb-4">
              <img src="images/certificate.png" alt="Academic" style="filter: opacity(0.7);">
              <h6 class="mb-0 text-white">Interaction and Networking Opportunities</h6>
            </div>
            <div class="d-flex gap-2 gap-sm-3 mb-3">
              <div class="reason_icon"><i class="fas fa-check"></i></div>
              <div class="reason_text">Build a robust network of like-minded professionals’ for long term career support.</div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="certificate_sec seciton_padding">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-sm-5 text-center">
          <img src="images/certificate.webp" width="274px" alt="Certificate" class="rounded CertificateHero">
        </div>
        <div class="col-sm-7 ps-3 ps-sm-5">
          <div class="headingbox mt-3 mt-sm-0">
            <h3>Get a UGC- Entitled Globally Recognized Degree</h3>
            <p><small>Degrees from Dr. D.Y Patil Vidyapeeth Online , Mumbai are :</small></p>
          </div>
          <ul class="certificat_list">
            <li> UGC-Entitled</li>
            <li> Degrees from a Globally Ranked University</li>
            <li> Globally Accepted in India and Abroad</li>
            <li> Equivalent to Dr. D.Y. Patil Vidyapeeth’s On-Campus Programme Degrees</li>
          </ul>
        </div>
      </div>
    </div>
  </section>

  <section class="specialization_sec" id="All-Course">
    <div class="container">
      <ul class="nav nav-pills mb-3 gap-2 justify-content-center" id="pills-tab" role="tablist">
        <li class="nav-item" role="presentation">
          <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="true">All Courses</button>
        </li>
        <li class="nav-item" role="presentation">
          <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="false">UG Courses</button>
        </li>
        <li class="nav-item" role="presentation">
          <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill" data-bs-target="#pills-contact" type="button" role="tab" aria-controls="pills-contact" aria-selected="false">PG Courses</button>
        </li>
      </ul>
      <div class="tab-content" id="pills-tabContent">
        <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
          <div class="container-fluid">
            <div class="row  justify-content-center">
              <div class="col-sm-12">
                <div class="text-center">
                  <h2 class="mb-4 fw-bold">Online Master’s & Bachelor’s Program</h2>
                </div>
              </div>
              <div class="col-lg-4 col-md-6 col-sm-6 mt-4 ReasonCardDiv">
                <div class="course_card h-100" type="button" data-bs-toggle="modal" data-bs-target="#apply_download">
                  <div class="card_img">
                    <img src="images/OnlineMBA.jpg" width="100%">
                  </div>
                  <div class="card-body">
                    <h5 class="fw-bold mb-4">Master of Business Administration</h5>
                    <p><i class="fas fa-users"></i> <b>Eligibility :</b> Bachelor’s (Recognized)</p>
                    <p><i class="far fa-clock"></i> <b>Duration :</b> 2 Years</p>
                    <p><i class="fas fa-rupee-sign"></i> <b>Fees :</b> ₹ 42,500/Semester</p>
                    <button class="btn button_main" style="width:100%">Apply Now</button>
                  </div>
                </div>
              </div>

              <div class="col-lg-4 col-md-6 col-sm-6 mt-4 ReasonCardDiv">
                <div class="course_card h-100" type="button" data-bs-toggle="modal" data-bs-target="#apply_download">
                  <div class="card_img">
                    <img src="images/OnlineBA.png" width="100%">
                  </div>
                  <div class="card-body">
                    <h5 class="fw-bold mb-4">Bachelor of Business Administration</h5>
                    <p><i class="fas fa-users"></i> <b>Eligibility :</b> 10+2 (Recognized)</p>
                    <p><i class="far fa-clock"></i> <b>Duration :</b> 3 Years</p>
                    <p><i class="fas fa-rupee-sign"></i> <b>Fees :</b> ₹ 18,500/Semester</p>
                    <button class="btn button_main" style="width:100%">Apply Now</button>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
        <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
          <div class="container-fluid">
            <div class="row  justify-content-center">
              <div class="col-sm-12">
                <div class="text-center">
                  <h2 class="mb-4 fw-bold">Online Bachelor’s Program</h2>
                </div>
              </div>
              <div class="col-lg-4 col-md-6 col-sm-6 mt-4 ReasonCardDiv">
                <div class="course_card h-100" type="button" data-bs-toggle="modal" data-bs-target="#apply_download">
                  <div class="card_img">
                    <img src="images/OnlineBA.png" width="100%">
                  </div>
                  <div class="card-body">
                    <h5 class="fw-bold mb-4">Bachelor of Business Administration</h5>
                    <p><i class="fas fa-users"></i> <b>Eligibility :</b> 10+2 (Recognized)</p>
                    <p><i class="far fa-clock"></i> <b>Duration :</b> 3 Years</p>
                    <p><i class="fas fa-rupee-sign"></i> <b>Fees :</b> ₹ 18,500/Semester</p>
                    <button class="btn button_main" style="width:100%">Apply Now</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="tab-pane fade" id="pills-contact" role="tabpanel" aria-labelledby="pills-contact-tab">
          <div class="container-fluid">
            <div class="row  justify-content-center">
              <div class="col-sm-12">
                <div class="text-center">
                  <h2 class="mb-4 fw-bold">Online Master’s Program</h2>
                </div>
              </div>
              <div class="col-lg-4 col-md-6 col-sm-6 mt-4 ReasonCardDiv">
                <div class="course_card h-100" type="button" data-bs-toggle="modal" data-bs-target="#apply_download">
                  <div class="card_img">
                    <img src="images/OnlineMBA.jpg" width="100%">
                  </div>
                  <div class="card-body">
                    <h5 class="fw-bold mb-4">Master of Business Administration</h5>
                    <p><i class="fas fa-users"></i> <b>Eligibility :</b> Bachelor’s (Recognized)</p>
                    <p><i class="far fa-clock"></i> <b>Duration :</b> 2 Years</p>
                    <p><i class="fas fa-rupee-sign"></i> <b>Fees :</b> ₹ 42,500/Semester</p>
                    <button class="btn button_main" style="width:100%">Apply Now</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="admission_sec seciton_padding">
    <div class="container">
      <div class="row">
        <div class="col-sm-12">
          <div class="headingbox">
            <h2 class="fw-bold text-center">Admission Process</h2>
          </div>
          <div class="steps_process d-flex bg-white px-3 py-4 rounded shadow">
            <div class="steps_card position-relative">
              <span class="position-relative">Step 1</span>
              <p>Fill in your basic details, Complete mobile number and email verification.</p>
            </div>
            <div class="steps_card position-relative">
              <span class="position-relative">Step 2</span>
              <p>Fill in personal info, education and employment details, upload photo and signature, pay fee online, submit form.</p>
            </div>
            <div class="steps_card position-relative">
              <span class="position-relative">Step 3</span>
              <p>After verifying all documents and fee receipts.</p>
            </div>
            <div class="steps_card position-relative">
              <span class="position-relative">Step 4</span>
              <p>An admission confirmation email and SMS with student login credentials and a link will be sent.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="work_sec seciton_padding">
    <div class="container">
      <div class="row">
        <div class="col-sm-12">
          <div class="headingbox text-center">
            <h3 class="fw-bold">Get your Dream Job with our Placement Services!</h3>
            <p>Our expert team and industry networks help you find the perfect career opportunities.</p>
          </div>
          <div class="owl-carousel owl-theme ourLearner">
            <div class="item">
              <img src="images/hiring1.webp" alt="Work">
            </div>
            <div class="item">
              <img src="images/hiring2.webp" alt="Work">
            </div>
            <div class="item">
              <img src="images/hiring3.webp" alt="Work">
            </div>
            <div class="item">
              <img src="images/hiring4.webp" alt="Work">
            </div>
            <div class="item">
              <img src="images/hiring5.webp" alt="Work">
            </div>
            <div class="item">
              <img src="images/hiring6.webp" alt="Work">
            </div>
            <div class="item">
              <img src="images/hiring7.webp" alt="Work">
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="tollfree_sec seciton_padding">
    <div class="container">
      <div class="row">
        <div class="col-sm-12 text-center text-white">
          <h5 class="fw-bold">For Queries , Feedback & Assistance</h5>
          <h4 class="fw-bold mb-4">Dr. D.Y.Patil Vidyapeeth Online Programs Learner Support</h4>
          <a class="btn bg-white" type="button" data-bs-toggle="modal" data-bs-target="#call_download">
            Apply Now</a>
        </div>
      </div>
    </div>
  </section>

  <footer class="bg-dark text-white">
    <div class="container">
      <div class="row" id="lpu_according">
        <div class="col-sm-12 pt-4 my-3 text-center">
          <p class="mb-1">I authorize a representative to contact me via phone and/or email. This will override registry on DND/NDNC.</p>
          <p class="mb-0">Copyright © 2024 | Dr. D.Y.Patil Vidyapeeth Online, Mumbai </p>
        </div>
      </div>
    </div>
  </footer>

  <!-- --------STICKY FOOTER MOBILE--------- -->
  <div class="sticky-footer d-flex d-sm-none">
    <button class="button_main btn" type="button" data-bs-toggle="modal" data-bs-target="#call_download" style="background: #de2739;">
      <div class="text-decoration-none text-light"> <i class="fas fa-phone-alt" aria-hidden="true"></i> Call Now</div>
    </button>
    <button class="button_main btn" type="button" data-bs-toggle="modal" data-bs-target="#whatsapp_download" style="background: #06b14a;">
      <i class="fab fa-whatsapp" aria-hidden="true"></i> Live Chat
    </button>
  </div>


  <!-- Modal1 brochure -->

  <div class="modal fade" id="brochur_download" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="brochur_downloadLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
      <div class="modal-content">
        <div class="modal-body pb-0">
          <div class="row">
            <div class="col-sm-5 position-relative formIMGDiv">
              <div class="form_img">
                <img src="images/university_banner.webp" width="100%">
              </div>
            </div>
            <div class="col-sm-7 common_formDiv ">
              <div class="common_form">
                <div class="text-end"><button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button></div>
                <div class="text-center mb-4">
                  <div class="logo mb-2">
                    <img src="images/logo.webp" alt="Logo" class="mainlogoss">
                  </div>
                  <h5 class="colorBlue">Get your Brochure Copy</h5>
                  <p class="mb-0">Fill in the below details to get a personalised brochure.</p>
                  <span class="d-block text-center text-danger fw-bold">Avail No Cost EMI's</span>
                </div>


                <form method="post" action="submit_form.php">
                  <input type="text" name="name" class="form-control" placeholder="Enter Name" required>
                  <input type="email" name="email" class="form-control" placeholder="Enter email" required>
                  <div class="position-relative">
                    <input type="tel" name="contactno" pattern="^[6-9]\d{9}$" maxlength="10" class="form-control" placeholder="Enter Phone No." required>
                    <span class="position-absolute end-0 me-2 px-2 rounded-bottom text-success" style="bottom: -13px; background-color: rgb(212, 254, 232); font-size: 10px;"><svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-shield-fill-check" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8 0c-.69 0-1.843.265-2.928.56-1.11.3-2.229.655-2.887.87a1.54 1.54 0 0 0-1.044 1.262c-.596 4.477.787 7.795 2.465 9.99a11.777 11.777 0 0 0 2.517 2.453c.386.273.744.482 1.048.625.28.132.581.24.829.24s.548-.108.829-.24a7.159 7.159 0 0 0 1.048-.625 11.775 11.775 0 0 0 2.517-2.453c1.678-2.195 3.061-5.513 2.465-9.99a1.541 1.541 0 0 0-1.044-1.263 62.467 62.467 0 0 0-2.887-.87C9.843.266 8.69 0 8 0zm2.146 5.146a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647z"></path>
                      </svg> We don't spam </span>
                  </div>
                  <select required name="city" class="form-select mb-3 stateData">
                    <option selected="" disabled="" value="">Select State </option>
                  </select>
                  <select required name="selectcourse" class="form-select mb-3">
                    <option value="" selected="" disabled="">Select Course</option>
                    <option value="1">MBA</option>
                    <option value="5">BBA</option>
                  </select>
                  <input type="hidden" value="pop" name="from">
                  <p class="py-1 px-2 rounded text-center" style="background:aliceblue;">
                    <small class="d-block">
                      <img src="images/certified-icon.svg" width="23px"> Only a certified mentor will assist you
                    </small>
                  </p>
                  <p class="text-center"><small>I authorize a representative to contact me via phone and/or email. This will override registry on DND/NDNC.</small></p>
                  <div class="text-center positon-relative">
                    <div class="disabledBtn d-none"></div>
                    <button type="submit" name="submit" class="button_main btn loader_btn"> <i class="fas fa-download"></i> Download Brochure</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>


  <!-- Modal2 apply-->
  <div class="modal fade" id="apply_download" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="apply_downloadLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-md">
      <div class="modal-content">
        <div class="modal-body pb-0">
          <div class="row">
            <div class="col-sm-12">
              <div class="common_form">
                <div class="text-end"><button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button></div>
                <div class="text-center mb-4">
                  <div class="logo mb-2">
                    <img src="images/logo.webp" alt="Logo" class="mainlogoss">
                  </div>
                  <p class="mb-0">Speak to an admission counsellor</p>
                  <span class="d-block text-center text-danger fw-bold">Avail No Cost EMI's</span>
                </div>


                <form method="post" action="submit_form.php">
                  <input type="text" name="name" class="form-control" placeholder="Enter Name" required>
                  <input type="email" name="email" class="form-control" placeholder="Enter email" required>
                  <div class="position-relative">
                    <input type="tel" name="contactno" pattern="^[6-9]\d{9}$" maxlength="10" class="form-control" placeholder="Enter Phone No." required>
                    <span class="position-absolute end-0 me-2 px-2 rounded-bottom text-success" style="bottom: -13px; background-color: rgb(212, 254, 232); font-size: 10px;"><svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-shield-fill-check" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8 0c-.69 0-1.843.265-2.928.56-1.11.3-2.229.655-2.887.87a1.54 1.54 0 0 0-1.044 1.262c-.596 4.477.787 7.795 2.465 9.99a11.777 11.777 0 0 0 2.517 2.453c.386.273.744.482 1.048.625.28.132.581.24.829.24s.548-.108.829-.24a7.159 7.159 0 0 0 1.048-.625 11.775 11.775 0 0 0 2.517-2.453c1.678-2.195 3.061-5.513 2.465-9.99a1.541 1.541 0 0 0-1.044-1.263 62.467 62.467 0 0 0-2.887-.87C9.843.266 8.69 0 8 0zm2.146 5.146a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647z"></path>
                      </svg> We don't spam </span>
                  </div>
                  <select required name="city" class="form-select mb-3 stateData">
                    <option selected="" disabled="" value="">Select State </option>
                  </select>
                  <select required name="selectcourse" class="form-select mb-3">
                    <option value="" selected="" disabled="">Select Course</option>
                    <option value="1">MBA</option>
                    <option value="5">BBA</option>
                  </select>
                  <input type="hidden" value="pop" name="from">
                  <p class="py-1 px-2 rounded text-center" style="background:aliceblue;">
                    <small class="d-block">
                      <img src="images/certified-icon.svg" width="23px"> Only a certified mentor will assist you
                    </small>
                  </p>
                  <p class="text-center"><small>I authorize a representative to contact me via phone and/or email. This will override registry on DND/NDNC.</small></p>
                  <div class="text-center positon-relative">
                    <div class="disabledBtn d-none"></div>
                    <button type="submit" name="submit" class="button_main btn loader_btn">Apply Now</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal3 call-->
  <div class="modal fade" id="call_download" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="call_downloadLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-md">
      <div class="modal-content">
        <div class="modal-body pb-0">
          <div class="row">
            <div class="col-sm-12">
              <div class="common_form">
                <div class="text-end"><button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button></div>
                <div class="text-center mb-4">
                  <div class="logo mb-2">
                    <img src="images/logo.webp" alt="Logo" class="mainlogoss">
                  </div>
                  <p>Talk To Your Dedicated Counselor</p>
                  <span class="d-block text-center text-danger fw-bold">Avail No Cost EMI's</span>
                </div>

                <form method="post" action="submit_form.php">
                  <input type="text" name="name" class="form-control" placeholder="Enter Name" required>
                  <input type="email" name="email" class="form-control" placeholder="Enter email" required>
                  <div class="position-relative">
                    <input type="tel" name="contactno" pattern="^[6-9]\d{9}$" maxlength="10" class="form-control" placeholder="Enter Phone No." required>
                    <span class="position-absolute end-0 me-2 px-2 rounded-bottom text-success" style="bottom: -13px; background-color: rgb(212, 254, 232); font-size: 10px;"><svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-shield-fill-check" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8 0c-.69 0-1.843.265-2.928.56-1.11.3-2.229.655-2.887.87a1.54 1.54 0 0 0-1.044 1.262c-.596 4.477.787 7.795 2.465 9.99a11.777 11.777 0 0 0 2.517 2.453c.386.273.744.482 1.048.625.28.132.581.24.829.24s.548-.108.829-.24a7.159 7.159 0 0 0 1.048-.625 11.775 11.775 0 0 0 2.517-2.453c1.678-2.195 3.061-5.513 2.465-9.99a1.541 1.541 0 0 0-1.044-1.263 62.467 62.467 0 0 0-2.887-.87C9.843.266 8.69 0 8 0zm2.146 5.146a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647z"></path>
                      </svg> We don't spam </span>
                  </div>
                  <select required name="city" class="form-select mb-3 stateData">
                    <option selected="" disabled="" value="">Select State </option>
                  </select>
                  <select required name="selectcourse" class="form-select mb-3">
                    <option value="" selected="" disabled="">Select Course</option>
                    <option value="1">MBA</option>
                    <option value="5">BBA</option>
                  </select>
                  <input type="hidden" value="pop" name="from">
                  <p class="py-1 px-2 rounded text-center" style="background:aliceblue;">
                    <small class="d-block">
                      <img src="images/certified-icon.svg" width="23px"> Only a certified mentor will assist you
                    </small>
                  </p>
                  <p class="text-center"><small>I authorize a representative to contact me via phone and/or email. This will override registry on DND/NDNC.</small></p>
                  <div class="text-center positon-relative">
                    <div class="disabledBtn d-none"></div>
                    <button type="submit" name="submit" class="button_main btn loader_btn" style="background: #de2739;">
                      <i class="fas fa-phone-alt"></i> Call Now
                    </button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal4 whatsapp -->

  <div class="modal fade" id="whatsapp_download" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="whatsapp_downloadLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-md">
      <div class="modal-content">
        <div class="modal-body pb-0">
          <div class="row">
            <div class="col-sm-12">
              <div class="common_form">
                <div class="text-end"><button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button></div>
                <div class="text-center mb-4">
                  <div class="logo mb-2">
                    <img src="images/logo.webp" alt="Logo" class="mainlogoss">
                  </div>
                  <p>Get in Touch with Live Counselors to get Detailed Information</p>
                  <span class="d-block text-center mt-3" style="color: #f58220;">Avail No Cost EMI's</span>
                </div>


                <form method="post" action="submit_form.php">
                  <input type="text" name="name" class="form-control" placeholder="Enter Name" required>
                  <input type="email" name="email" class="form-control" placeholder="Enter email" required>
                  <div class="position-relative">
                    <input type="tel" name="contactno" pattern="^[6-9]\d{9}$" maxlength="10" class="form-control" placeholder="Enter Phone No." required>
                    <span class="position-absolute end-0 me-2 px-2 rounded-bottom text-success" style="bottom: -13px; background-color: rgb(212, 254, 232); font-size: 10px;"><svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-shield-fill-check" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8 0c-.69 0-1.843.265-2.928.56-1.11.3-2.229.655-2.887.87a1.54 1.54 0 0 0-1.044 1.262c-.596 4.477.787 7.795 2.465 9.99a11.777 11.777 0 0 0 2.517 2.453c.386.273.744.482 1.048.625.28.132.581.24.829.24s.548-.108.829-.24a7.159 7.159 0 0 0 1.048-.625 11.775 11.775 0 0 0 2.517-2.453c1.678-2.195 3.061-5.513 2.465-9.99a1.541 1.541 0 0 0-1.044-1.263 62.467 62.467 0 0 0-2.887-.87C9.843.266 8.69 0 8 0zm2.146 5.146a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647z"></path>
                      </svg> We don't spam </span>
                  </div>
                  <select required name="city" class="form-select mb-3 stateData">
                    <option selected="" disabled="" value="">Select State </option>
                  </select>
                  <select required name="selectcourse" class="form-select mb-3">
                    <option value="" selected="" disabled="">Select Course</option>
                    <option value="1">MBA</option>
                    <option value="5">BBA</option>
                  </select>
                  <input type="hidden" value="pop" name="from">
                  <p class="py-1 px-2 rounded text-center" style="background:aliceblue;">
                    <small class="d-block">
                      <img src="images/certified-icon.svg" width="23px"> Only a certified mentor will assist you
                    </small>
                  </p>
                  <p class="text-center"><small>I authorize a representative to contact me via phone and/or email. This will override registry on DND/NDNC.</small></p>
                  <div class="text-center positon-relative">
                    <div class="disabledBtn d-none"></div>
                    <button type="submit" name="submit" class="button_main btn loader_btn" style="background: #06b14a;">
                      <i class="fab fa-whatsapp"></i> Live Chat</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  <script src="js/owl.carousel.min.js"></script>
  <script src="js/bootstrap.bundle.min.js"></script>

  <script>
    $(document).ready(function() {
      var timeoutId = setTimeout(function() {
        $(".clickPop").trigger('click');
      }, 10000);

      $('.button_main').click(function() {
        clearTimeout(timeoutId);
      });
      $('.popDisabled').click(function() {
        clearTimeout(timeoutId);
      });


    });
  </script>

  <script>
    $('.topRanked').owlCarousel({
      loop: true,
      margin: 10,
      nav: false,
      autoplay: true,
      autoplayTimeout: 5000,
      responsive: {
        0: {
          items: 1
        },
        500: {
          items: 2
        },
        1000: {
          items: 3
        },
        1200: {
          items: 4
        }
      }
    })

    $('.ourLearner').owlCarousel({
      loop: true,
      nav: false,
      autoplay: true,
      autoplayTimeout: 3000,
      responsive: {
        0: {
          items: 1
        },
        400: {
          items: 1
        },
        540: {
          items: 2
        },
        700: {
          items: 3
        },
        1000: {
          items: 4
        },
		1200: {
          items: 6
        }  
      }
    })
  </script>

 <!-- <script>
    $(document).ready(function() {
      $("form").submit(function() {
        $(".loader_btn").html('<div class="spinner-border spinner-border-sm" role="status"> <span class="visually-hidden"></span></div> Please Wait...');
        $(".disabledBtn").removeClass("d-none");
      });
    });
  </script> -->

  <script>
    $(document).ready(function() {
      $("form").submit(function(event) {
        var $submitButton = $(this).find("button[type='submit']");
        if ($submitButton.hasClass('disabled')) {
          // If the button is already disabled, prevent form submission
          event.preventDefault();
          return;
        }

        // Add spinner and disable the button
        $(".loader_btn").html('<div class="spinner-border spinner-border-sm" role="status"> <span class="visually-hidden"></span></div> Please Wait...');
        $(".disabledBtn").removeClass("d-none");
        $submitButton.addClass('disabled');

        // Allow the form to be submitted
        return true;
      });
    });
  </script>

  <script>
    $(document).ready(function() {
      $("input[name='email']").change(function(e) {
        let elementValue = e.target.value;
        $.ajax({
          type: 'POST',
          url: 'https://distancemca.collegevidya.in/check_email.php',
          data: 'emails=' + elementValue,
          success: function(response) {
            if (response != "ok") {
              e.target.value = "";
              alert("Invalid Email");
            }

          }
        });
      });
    });

    $(document).ready(function() {
      $("input[name='contactno']").change(function(e) {
        let elementValuenumber = e.target.value;
        result = elementValuenumber.substring(0, 1);
        if (result < 5) {
          e.target.value = "";
          alert("Invalid Number");
        }
      });
    });

    // ---------Form Course By University-------- //

    const formElements = document.querySelectorAll("form");

    formElements.forEach((form) => {
      const selectElement = form.querySelector(".stateData");

      fetch('https://admin.collegevidya.com/state/')
        .then(response => response.json())
        .then(data => {
          data.forEach(option => {
            selectElement.insertAdjacentHTML("beforeend", `<option value='${option.id}'> ${option.state} </option>`);
          });
        })
        .catch(error => {
          console.error("Error fetching state data:", error);
        });
    });
  </script>
</body>

</html>